/*
 * Abstract Factory
 *
 * Our extended classes represent various systems, creating objects which are 
 * (would be) uniquely tuned to interact with the component for that system.
 *
 * Each class 
*/
abstract class AbstractMoonFactory
{
   // Factory method
   public static AbstractMoonFactory getFactory(String system)
   throws NoFactoryException
   {
      // Get the singleton for the specified input system
      if (system.equals("Moon"))
         return Moon.getInstance();
      else if (system.equals("AdvancedMoon"))
         return AdvancedMoon.getInstance();
      else if (system.equals("SuperMoon"))
         return SuperMoon.getInstance();
      else if (system.equals("UltraMoon"))
         return UltraMoon.getInstance();
      
      // If we haven't returned, then we were passed a string that doesn't
      // repesent a real system.  Throw an exception
      throw new NoFactoryException();
   }
   
   abstract AbstractCPU CPU();
   abstract AbstractMMU MMU();
   abstract AbstractMotherboard Motherboard();
}


class Moon extends AbstractMoonFactory
{
   private static AbstractMoonFactory me;
   public static AbstractMoonFactory getInstance()
   {
      if (me == null) me = new Moon();
      return me;
   }
   public AbstractCPU CPU() { return new MoonCPU(); }
   public AbstractMMU MMU() { return new MoonMMU(); }
   public AbstractMotherboard Motherboard() { return new MoonMotherboard(); }
}


class AdvancedMoon extends AbstractMoonFactory
{
   private static AbstractMoonFactory me;
   public static AbstractMoonFactory getInstance()
   {
      if (me == null) me = new AdvancedMoon();
      return me;
   }
   public AbstractCPU CPU() { return new AdvancedCPU(); }
   public AbstractMMU MMU() { return new AdvancedMMU(); }
   public AbstractMotherboard Motherboard() { return new AdvancedMotherboard(); }
}


class SuperMoon extends AbstractMoonFactory
{
   private static AbstractMoonFactory me;
   public static AbstractMoonFactory getInstance()
   {
      if (me == null) me = new SuperMoon();
      return me;
   }
   public AbstractCPU CPU() { return new SuperCPU(); }
   public AbstractMMU MMU() { return new SuperMMU(); }
   public AbstractMotherboard Motherboard() { return new SuperMotherboard(); }
}


class UltraMoon extends AbstractMoonFactory
{
   private static AbstractMoonFactory me;
   public static AbstractMoonFactory getInstance()
   {
      if (me == null) me = new UltraMoon();
      return me;
   }
   public AbstractCPU CPU() { return new UltraCPU(); }
   public AbstractMMU MMU() { return new UltraMMU(); }
   public AbstractMotherboard Motherboard() { return new UltraMotherboard(); }
}


class NoFactoryException extends Exception {}